﻿using System;
using System.Collections.Generic;
using System.ComponentModel.DataAnnotations;
using System.Linq;
using System.Web;

namespace NVCC.WebUI.Models
{
    public class AnnouncementItemViewModel
    {
        public string AnnouncementType { get; set; }
        private DateTime? startDT;
        [Display(Name = "Announcement start time (local time in YYYY/MM/DD HH:MM format) (leave blank to start immediately)")]
        [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:yyyy/MM/dd HH:mm}")]
        [DataType(DataType.Date, ErrorMessage = "Announcement Start Time must be in YYYY/MM/DD HH:MM format.")]
        [RegularExpression(@"^(?:(?!0000)[0-9]{4}\/(?:(?:0[1-9]|1[0-2])\/(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])\/(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\s([01][0-9]|2[0-3]):[0-5][0-9]$", ErrorMessage = "Announcement Start Time must be in YYYY/MM/DD HH:MM format.")]
        public DateTime? StartDT
        {
            get
            {
                return startDT;
            }
            set
            {
                // the value that comes in _will_ be in UTC
                if (value != null)
                {
                    startDT = DateTime.SpecifyKind((DateTime)value, DateTimeKind.Utc);
                }
                else
                {
                    startDT = null;
                }
            }
        }
        private DateTime? expirationDT;
        [Display(Name = "Expiration date (local time in YYYY/MM/DD HH:MM format)")]
        [DisplayFormat(ApplyFormatInEditMode = true, DataFormatString = "{0:yyyy/MM/dd HH:mm}")]
        [DataType(DataType.DateTime, ErrorMessage = "Expiration Date must be in YYYY/MM/DD HH:MM format.")]
        [RegularExpression(@"^(?:(?!0000)[0-9]{4}\/(?:(?:0[1-9]|1[0-2])/(?:0[1-9]|1[0-9]|2[0-8])|(?:0[13-9]|1[0-2])\/(?:29|30)|(?:0[13578]|1[02])-31)|(?:[0-9]{2}(?:0[48]|[2468][048]|[13579][26])|(?:0[48]|[2468][048]|[13579][26])00)-02-29)\s([01][0-9]|2[0-3]):[0-5][0-9]$", ErrorMessage = "Expiration Date must be in YYYY/MM/DD HH:MM format.")]
        public DateTime? ExpirationDT
        {
            get
            {
                return expirationDT;
            }
            set
            {
                // the value that comes in _will_ be in UTC
                if (value != null)
                {
                    expirationDT = DateTime.SpecifyKind((DateTime)value, DateTimeKind.Utc);
                }
                else
                {
                    expirationDT = null;
                }
            }
        }
        public string Text { get; set; }
    }
}